<?php
// Database connection parameters
$host = 'localhost'; // Change this to your database host
$dbname = 'lottery'; // Change this to your database name
$username = 'root'; // Change this to your database username
$password = ''; // Change this to your database password

try {
    // Create a new PDO instance
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Prepare and execute the SQL statement to fetch all entries
    $stmt = $pdo->prepare("SELECT * FROM lottery_entries");
    $stmt->execute();

    // Fetch all results
    $entries = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    // Handle any errors during the database connection or query execution
    die("Error: " . $e->getMessage());
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lottery Entries</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
</head>
<body>
    <div class="container mt-5">
        <h2>Lottery Entries</h2>
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Board Number</th>
                    <th>Main Numbers</th>
                    <th>Special Number</th>
                    <th>Created At</th>
                </tr>
            </thead>
            <tbody>
                <?php if (count($entries) > 0): ?>
                    <?php foreach ($entries as $entry): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($entry['id']); ?></td>
                            <td><?php echo htmlspecialchars($entry['board_number']); ?></td>
                            <td><?php echo htmlspecialchars($entry['main_numbers']); ?></td>
                            <td><?php echo htmlspecialchars($entry['special_number']); ?></td>
                            <td><?php echo htmlspecialchars($entry['created_at']); ?></td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="5" class="text-center">No entries found.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</body>
</html>