<?php 
include 'header.php'; 



// Get the blog ID from the URL
$blog_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

// Fetch the blog post based on the ID
$sql = "SELECT * FROM blogs WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $blog_id);
$stmt->execute();
$result = $stmt->get_result();

// Check if a blog post was found
if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
} else {
    echo "Blog post not found.";
    exit();
}

// Fetch comments for the specific blog post
$sql_comments = "SELECT * FROM comments WHERE post_id = ? ORDER BY created_at DESC";
$stmt_comments = $conn->prepare($sql_comments);
$stmt_comments->bind_param("i", $blog_id);
$stmt_comments->execute();
$result_comments = $stmt_comments->get_result();

// Close the connection
$stmt->close();
$stmt_comments->close();


$post_id = $blog_id; // Replace with your actual post ID

// Prepare and bind
$stmmt = $conn->prepare("INSERT INTO post_views (post_id) VALUES (?)");
$stmmt->bind_param("i", $post_id); // "i" indicates the variable type is integer

// Execute the statement
if ($stmmt->execute()) {
    
} else {
    echo "Error: " . $stmmt->error;
}

// Close the statement and connection
$stmmt->close();
?>

<section class="breadcrumb-area">
    <div class="container">
        <div class="content">
            <h2 class="title">Blog Single</h2>
            <ul class="breadcrumb-list extra-padding">
                <li>
                    <a href="index.html">Home</a>
                </li>
                <li>
                    <a href="#">Blog Single</a>
                </li>
            </ul>
        </div>
    </div>
</section>
<!-- ==========Breadcrumb-Section========== -->

<!-- ==========Blog-Page========== -->
<section class="blog-page">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-10">
                <div class="post-details">
                    <div class="content">
                        <div class="top-area">
                        

                        <?php
                          $post_id = 1; // Replace with your actual post ID

// Prepare the SQL statement
$stmt = $conn->prepare("SELECT viewed_at FROM post_views WHERE post_id = ? ORDER BY viewed_at DESC LIMIT 1");
$stmt->bind_param("i", $post_id); // "i" indicates the variable type is integer

// Execute the statement
$stmt->execute();

// Bind the result
$stmt->bind_result($viewed_at);

// Fetch the result
if ($stmt->fetch()) {
     // Create DateTime objects
     $viewedAtTime = new DateTime($viewed_at);
     $currentTime = new DateTime();
 
     // Calculate the difference
     $interval = $viewedAtTime->diff($currentTime);
 
     // Format the difference into a human-readable string
     $timeDifference = '';
     if ($interval->y > 0) {
         $timeDifference .= $interval->y . ' year' . ($interval->y > 1 ? 's' : '') . ', ';
     }
     if ($interval->m > 0) {
         $timeDifference .= $interval->m . ' month' . ($interval->m > 1 ? 's' : '') . ', ';
     }
     if ($interval->d > 0) {
         $timeDifference .= $interval->d . ' day' . ($interval->d > 1 ? 's' : '') . ', ';
     }
     if ($interval->h > 0) {
         $timeDifference .= $interval->h . ' hour' . ($interval->h > 1 ? 's' : '') . ', ';
     }
     if ($interval->i > 0) {
         $timeDifference .= $interval->i . ' minute' . ($interval->i > 1 ? 's' : '') . ', ';
     }
     if ($interval->s > 0) {
         $timeDifference .= $interval->s . ' second' . ($interval->s > 1 ? 's' : '');
     }
 
     // Trim the last comma and space if needed
     $timeDifference = rtrim($timeDifference, ', ');
    echo "<p class='date'><span>Last viewed: " . htmlspecialchars($timeDifference) ." ago</span></p>";
} else {
    echo "<p class='date'><span>No views found for this post.</span></p>";
}

// Close the statement and connection
$stmt->close();
$conn->close();
?>
                                
                            <h4 class="title"><?php echo htmlspecialchars($row['title']); ?></h4>
                        </div>
                        <div class="main-content">
                            <div class="left">
                                <div class="avatar">
                                    <img src="assets/images/blog-avatar.png" alt="">
                                </div>
                                <ul class="meta-list">
                                    <li>
                                        <a href="#">
                                            <i class="far fa-comments"></i>
                                        </a>
                                        <span><?php echo $result_comments->num_rows; ?></span>
                                    </li>
                                    <li>
    <a href="#" onclick="likePost(<?php echo $row['id']; ?>)">
        <i class="fas fa-thumbs-up"></i> Like
    </a>
    <span id="like-count"><?php echo $row['like_count']; ?></span>
</li>
<li>
    <a href="#" onclick="dislikePost(<?php echo $row['id']; ?>)">
        <i class="fas fa-thumbs-down"></i> Dislike
    </a>
    <span id="dislike-count"><?php echo $row['dislike_count']; ?></span>
</li>
                                </ul>
                            </div>
                            <div class="right">
                                <div class="post-content">
                                    <p><?php echo nl2br(htmlspecialchars($row['content'])); ?></p>
                                    <img src="<?php echo htmlspecialchars($row['image']); ?>" alt="">
                                </div>
                                <div class="tags-area">
                                    <div class="tags">
                                        <span>Tags :</span>
                                        <div class="tags-item">
                                            <a href="#">Tickets</a>
                                            <a href="#">Coming Soon</a>
                                            <a href="#">Movies</a>
                                        </div>
                                    </div>
                                    <ul class="social-icons">
                                        <li><a href="#"><i class="fab fa-facebook-f"></i></a></li>
                                        <li><a href="#"><i class="fab fa-twitter"></i></a></li>
                                        <li><a href="#"><i class="fab fa-instagram"></i></a></li>
                                        <li><a href="#"><i class="fab fa-pinterest"></i></a></li>
                                        <li><a href="#"><i class="fab fa-google"></i></a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="blog-comment">
                    <h5 class="title">Comments</h5>
 <ul class="comment-area">
                        <?php while ($comment = $result_comments->fetch_assoc()): ?>
                            <li>
                                <div class="blog-thumb-info">
                                    <span><?php echo date("d M, Y", strtotime($comment['created_at'])); ?></span>
                                    <h6 class="title"><a href="#"><?php echo htmlspecialchars($comment['author']); ?></a></h6>
                                </div>
                                <div class="blog-content">
                                    <p><?php echo nl2br(htmlspecialchars($comment['content'])); ?></p>
                                </div>
                            </li>
                        <?php endwhile; ?>
                    </ul>
                </div>

                <div class="leave-comment">
                    <h5 class="title">Leave a Comment</h5>
                    <form class="blog-form" method="post" action="submit_comment.php">
                        <div class="form-group">
                            <input type="text" class="form-control" name="author" placeholder="Enter Your Full Name" required>
                        </div>
                        <div class="form-group">
                            <textarea name="content" placeholder="Write A Message" class="form-control" required></textarea>
                        </div>
                        <input type="hidden" name="post_id" value="<?php echo $blog_id; ?>">
                        <div class="form-group">
                            <button class="custom-button2" type="submit">Submit Now</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- ==========Blog-Page========== -->
<script>
    function likePost(postId) {
        fetch('update_like_count.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({ post_id: postId })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                document.getElementById('like-count').innerText = data.new_count;
            } else {
                alert('Error updating like count.');
            }
        })
        .catch(error => console.error('Error:', error));
    }

    function dislikePost(postId) {
        fetch('update_dislike_count.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({ post_id: postId })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                document.getElementById('dislike-count').innerText = data.new_count;
            } else {
                alert('Error updating dislike count.');
            }
        })
        .catch(error => console.error('Error:', error));
    }
</script>
<?php include 'footer.php'; ?>