<?php
// Database connection parameters
include 'config.php'; // Your database connection

// Check if the form is submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Get the form data
    $title = $_POST['title'];
    $author = $_POST['author'];

    // Get the three paragraphs and concatenate them
    $content1 = $_POST['content1'];
    $content2 = $_POST['content2'];
    $content3 = $_POST['content3'];
    $content = $content1 . "\n\n" . $content2 . "\n\n" . $content3;

    // Handle the image upload
    $targetDir = "images/upload/"; // Folder where you want to save the images
    $imageFileType = strtolower(pathinfo($_FILES["image"]["name"], PATHINFO_EXTENSION));
    $targetFile = $targetDir . uniqid() . '.' . $imageFileType; // Create a unique file name

    // Check if the file is a valid image
    $check = getimagesize($_FILES["image"]["tmp_name"]);
    if($check === false) {
        die("File is not an image.");
    }

    // Check file size (limit to 5MB)
    if ($_FILES["image"]["size"] > 5000000) {
        die("Sorry, your file is too large.");
    }

    // Allow certain file formats
    if(!in_array($imageFileType, ['jpg', 'png', 'jpeg', 'gif'])) {
        die("Sorry, only JPG, JPEG, PNG & GIF files are allowed.");
    }

    // Attempt to upload the file
    if (move_uploaded_file($_FILES["image"]["tmp_name"], $targetFile)) {
        // Prepare and bind
        $stmt = $conn->prepare("INSERT INTO blogs (title, image, author, content) VALUES (?, ?, ?, ?)");
        $stmt->bind_param("ssss", $title, $targetFile, $author, $content);

        // Execute the statement
        if ($stmt->execute()) {
            echo "<script>
            alert('New blog post created successfully!');
            window.location.href = 'admin.php'; // Change this to your desired page
          </script>";
        } else {
            echo "Error: " . $stmt->error;
        }

        // Close the statement
        $stmt->close();
    } else {
        echo "Sorry, there was an error uploading your file.";
    }
}

// Close the connection
$conn->close();
?>



