<?php
include 'config.php'; // Include your database connection file

// Get the POST data
// Get the POST data
$data = json_decode(file_get_contents('php://input'), true);
$post_id = intval($data['post_id']);

// Update the like count in the database
$sql = "UPDATE blogs SET like_count = like_count + 1 WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $post_id);
$stmt->execute();

// Check if the update was successful
if ($stmt->affected_rows > 0) {
    // Get the new like count
    $stmt = $conn->prepare("SELECT like_count FROM blogs WHERE id = ?");
    $stmt->bind_param("i", $post_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $row = $result->fetch_assoc();

    // Return the new like count as a JSON response
    echo json_encode(['success' => true, 'new_count' => $row['like_count']]);
} else {
    echo json_encode(['success' => false]);
}

// Close the statement and connection
$stmt->close();
$conn->close();
?>