<?php
session_start(); 
if(!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !==true) {
    header("location: index.php");
}

$user_id = $_SESSION['user_id'];
$game_name = $_SESSION['gamename'];
$payment_plan = $_SESSION['payment_plan']; // Assuming payment plan is stored in session

// Database connection parameters
$host = 'localhost';
$dbname = 'lottery';
$username = 'root';
$password = '';

try {
    // Create a new PDO instance
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Check if lottery_data is set in the POST request
    if (isset($_POST['lottery_data'])) {
        $lotteryData = $_POST['lottery_data'];

        // Prepare the SQL statement
        $stmt = $pdo->prepare("INSERT INTO lottery_entries (user_id, game_name, board_number, main_numbers, special_number) VALUES (:user_id, :game_name, :board_number, :main_numbers, :special_number)");

        // Loop through each lottery board data
        foreach ($lotteryData as $data) {
            $boardNumber = $data['board_number'];
            $mainNumbers = implode(',', $data['main_numbers']); // Convert array to comma-separated string
            $specialNumber = $data['special_number'];

            // Bind parameters and execute the statement
            $stmt->execute([
                ':user_id' => $user_id,
                ':game_name' => $game_name,
                ':board_number' => $boardNumber,
                ':main_numbers' => $mainNumbers,
                ':special_number' => $specialNumber
            ]);
            $_SESSION['game'] = $game_name;
        }

        // Return a success response
        echo json_encode(['status' => 'success']);
        include 'jeckpot.php'; 
    } else {
        // Return an error response if no lottery data is sent
        echo json_encode(['status' => 'error', 'message' => 'No lottery data received.']);
    }
    
} catch (PDOException $e) {
    // Handle any errors during the database connection or query execution
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
?>
