<?php
session_start();

include 'config.php'; 

// Get data from POST request
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $email = $_POST['email'];
    $password = $_POST['password'];

    // Prepare and bind
    $stmt = $conn->prepare("SELECT `id`, `name`, `surname`, `nickname`, `email`, `phone`, `password`, `role` FROM users WHERE email = ?");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $stmt->store_result();
    
    if ($stmt->num_rows > 0) {
        $stmt->bind_result($id, $name, $surname, $nickname, $email, $phone, $hashed_password, $role);
        $stmt->fetch();
        
        // Verify password
        if (password_verify($password, $hashed_password)) {
            $_SESSION['user_id'] = $id; // Store user ID in session
            $_SESSION['user_name'] = $name;
            $_SESSION['surname'] = $surname;
            $_SESSION['email'] = $email;
            $_SESSION['phone'] = $phone;
            $_SESSION['role'] = $role; // Store user role in session
            $_SESSION["loggedin"] = true;

            // Redirect based on user role
            if ($role === 'Admin') {
                header("location: admin.php");
            } else {
                header("location: home.php");
            }
            exit(); // Always exit after redirecting
        } else {
            echo '<script>alert("Invalid password.");</script>';
        }
    } else {
        echo '<script>alert("No user found with that email.");</script>';
    }

    $stmt->close();
}

$conn->close();
?>