<?php

include 'config.php'; 
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">

    <link rel="stylesheet" href="css/bootstrap.min.css">
    <link rel="stylesheet" href="css/all.min.css">
    <link rel="stylesheet" href="css/magnific-popup.css">
    <link rel="stylesheet" href="css/owl.carousel.min.css">
    <link rel="stylesheet" href="css/owl.theme.default.min.css">
    <link rel="stylesheet" href="css/nice-select.css">
    <link rel="stylesheet" href="css/bootstrap-popover-x.min.css">
    <link rel="stylesheet" href="css/main.css">
    <link rel="stylesheet" href="css/responsive.css">
    <link rel="shortcut icon" href="images/logo.png" type="image/x-icon">
    <title>YesFreeLotto</title>
    <script src="https://js.paystack.co/v2/inline.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <style>
        
        .error-message {
            color: red;
            display: none;
        }
        
    </style>
</head>

<body>
    <!-- ==========Preloader========== -->
    <div class="preloader">
        <div class="preloader-inner">
            <div class="preloader-icon">
                <span></span>
                <span></span>
            </div>
        </div>
    </div>
    <!-- ==========Preloader========== -->

    <!-- ==========Overlay========== -->
    <div class="overlay"></div>
    <a href="#" class="scrollToTop">
        <i class="fas fa-angle-up"></i>
    </a>
    <!-- ==========Overlay========== -->

    <!-- ==========Header-Section========== -->
    <header class="top-header">
        <div class="header-top-area">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="header-top-area-inner">
                            <a href="index.html" class="logo">
                                <img src="images/logo.png" alt>
                            </a>
                            <div class="right-area">
                                <div class="log-reg-area">
                                    <a href="#" class="custom-button1" data-toggle="modal" data-target="#registerModal">Register</a>
                                    <a href="#" class="custom-button2" data-toggle="modal" data-target="#loginModal">Log
                                        In</a>
                                </div>
                                <div class="cart-area">
                                    <!--<div class="icon">
                                        <img src="images/cart.png" alt>
                                        <span>06</span>
                                    </div>
                                    <div class="amount">
                                        <h4 class="mony">$ 23.60</h4>
                                        <p>To checkout</p>
                                    </div>-->
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="header-section">
            <div class="container">
                <div class="header-wrapper">
                <?php
// Get the current page name
$current_page = basename($_SERVER['PHP_SELF']);
?>

<ul class="menu">
    <li>
        <a href="index.php" class="<?php echo ($current_page == 'index.php') ? 'active' : ''; ?>">Home</a>
    </li>
    <li>
        <a href="" class="<?php echo ($current_page == 'lottery.php') ? 'active' : ''; ?>">Lottery</a>
    </li>
    <li>
        <a href="" class="<?php echo ($current_page == 'results.php') ? 'active' : ''; ?>">Results</a>
    </li>
    <li>
        <a href="about.php" class="<?php echo ($current_page == 'about.php') ? 'active' : ''; ?>">About</a>
    </li>
    <li>
        <a href="faq.php" class="<?php echo ($current_page == 'faq.php') ? 'active' : ''; ?>">Faq</a>
    </li>
    <li>
        <a href="#">Blog</a>
        <ul class="submenu">
            <li>
                <a href="blog1.php" class="<?php echo ($current_page == 'blog1.php') ? 'active' : ''; ?>">Blog</a>
            </li>
            <li>
                <a href="how_it_works.php" class="<?php echo ($current_page == 'how_it_works.php') ? 'active' : ''; ?>">HOW IT WORK</a>
            </li>
        </ul>
    </li>
    <li>
        <a href="contact.html" class="<?php echo ($current_page == 'contact.php') ? 'active' : ''; ?>">History</a>
    </li>
</ul>
                    <div class="right-tools">
                        <!--<select class="select-bar">
                            <option value>BTC</option>
                            <option value>BDT</option>
                            <option value>USD</option>
                        </select>
                        <select class="select-bar">
                            <option value>EN</option>
                            <option value>IN</option>
                            <option value>BN</option>
                        </select>-->
                    </div>
                    <div class="header-bar d-lg-none">
                        <span></span>
                        <span></span>
                        <span></span>
                    </div>
                </div>
            </div>
        </div>
    </header>
      <!-- Register Area -->
      <div class="modal fade log-reg-modal-wrapper" id="registerModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-body">
                    <div class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </div>
                    <div class="log-reg-inner">
                        <h2 class="title">
                            Create an Account
                        </h2>
                        <div class="main-content">
                            <form action="register.php" method="POST">
                            <div class="form-group">
                                    <label>Your Name</label>
                                    <input type="text" name="name" class="my-form-control" placeholder="Enter Your Name" required>
                                </div>
                                <div class="form-group">
                                    <label>Your Surname</label>
                                    <input type="text" name="surname" class="my-form-control" placeholder="Enter Your Surname" required>
                                </div>
                                <div class="form-group">
                                    <label>Your Nickname</label>
                                    <input type="text" name="nickname" class="my-form-control" placeholder="Enter Your Nickname" required>
                                </div>
                                <div class="form-group">
                                    <label>Your Email</label>
                                    <input type="email" name="email" class="my-form-control" placeholder="Enter Your Email" required>
                                </div>
                                <div class="form-group">
                                <label>Select Your Country</label>
                                <select class="my-form-control" id="countrySelect" name="country" required>
                                    <option value="" disabled selected>Select your country</option>
                                    <option value="DZ" data-flag="images/flags/dz.png" data-code="+213">Algeria</option>
                                    <option value="AO" data-flag="images/flags/ao.png" data-code="+244">Angola</option>
                                    <option value="BJ" data-flag="images/flags/bj.png" data-code="+229">Benin</option>
                                    <option value="BW" data-flag="images/flags/bw.png" data-code="+267">Botswana</option>
                                    <option value="BF" data-flag="images/flags/bf.png" data-code="+226">Burkina Faso</option>
                                    <option value="BI" data-flag="images/flags/bi.png" data-code="+257">Burundi</option>
                                    <option value="CV" data-flag="images/flags/cv.png" data-code="+238">Cabo Verde</option>
                                    <option value="CM" data-flag="images/flags/cm.png" data-code="+237">Cameroon</option>
                                    <option value="CA" data-flag="images/flags/ca.png" data-code="+1">Canada</option>
                                    <option value="CF" data-flag="images/flags/cf.png" data-code="+236">Central African Republic</option>
                                    <option value="TD" data-flag="images/flags/td.png" data-code="+235">Chad</option>
                                    <option value="KM" data-flag="images/flags/km.png" data-code="+269">Comoros</option>
                                    <option value="CG" data-flag="images/flags/cg.png" data-code="+242">Congo</option>
                                    <option value="CD" data-flag="images/flags/cd.png" data-code="+243">Democratic Republic of the Congo</option>
                                    <option value="DJ" data-flag="images/flags/dj.png" data-code="+253">Djibouti</option>
                                    <option value="EG" data-flag="images/flags/eg.png" data-code="+20">Egypt</option>
                                    <option value="GQ" data-flag="images/flags/gq.png" data-code="+240">Equatorial Guinea</option>
                                    <option value="ER" data-flag="images/flags/er.png" data-code="+291">Eritrea</option>
                                    <option value="SZ" data-flag="images/flags/sz.png" data-code="+268">Eswatini</option>
                                    <option value="ET" data-flag="images/flags/et.png" data-code="+251">Ethiopia</option>
                                    <option value="GA" data-flag="images/flags/ga.png" data-code="+241">Gabon</option>
                                    <option value="GM" data-flag="images/flags/gm.png" data-code="+220">Gambia</option>
                                    <option value="GH" data-flag="images/flags/gh.png" data-code="+233">Ghana</option>
                                    <option value="GN" data-flag="images/flags/gn.png" data-code="+224">Guinea</option>
                                    <option value="GW" data-flag="images/flags/gw.png" data-code="+245">Guinea-Bissau</option>
                                    <option value="KE" data-flag="images/flags/ke.png" data-code="+254">Kenya</option>
                                    <option value="LS" data-flag="images/flags/ls.png" data-code="+266">Lesotho</option>
                                    <option value="LR" data-flag="images/flags/lr.png" data-code="+231">Liberia</option>
                                    <option value="LY" data-flag="images/flags/ly.png" data-code="+218">Libya</option>
                                    <option value="MG" data-flag="images/flags/mg.png" data-code="+261">Madagascar</option>
                                    <option value="MW" data-flag="images/flags/mw.png" data-code="+265">Malawi</option>
                                    <option value="ML" data-flag="images/flags/ml.png" data-code="+223">Mali</option>
                                    <option value="MR" data-flag="images/flags/mr.png" data-code="+222">Mauritania</option>
                                    <option value="MU" data-flag="images/flags/mu.png" data-code="+230">Mauritius</option>
                                    <option value="YT" data-flag="images/flags/yt.png" data-code="+262">Mayotte</option>
                                    <option value="MA" data-flag="images/flags/ma.png" data-code="+212">Morocco</option>
                                    <option value="MZ" data-flag="images/flags/mz.png" data-code="+258">Mozambique</option>
                                    <option value="NA" data-flag="images/flags/na.png" data-code="+264">Namibia</option>
                                    <option value="NE" data-flag="images/flags/ne.png" data-code="+227">Niger</option>
                                    <option value="NG" data-flag="images/flags/ng.png" data-code="+234">Nigeria</option>
                                    <option value="RW" data-flag="images/flags/rw.png" data-code="+250">Rwanda</option>
                                    <option value="RE" data-flag="images/flags/re.png" data-code="+262">Réunion</option>
                                    <option value="ST" data-flag="images/flags/st.png" data-code="+239">São Tomé and Principe</option>
                                    <option value="SN" data-flag="images/flags/sn.png" data-code="+221">Senegal</option>
                                    <option value="SC" data-flag="images/flags/sc.png" data-code="+248">Seychelles</option>
                                    <option value="SL" data-flag="images/flags/sl.png" data-code="+232">Sierra Leone</option>
                                    <option value="SO" data-flag="images/flags/so.png" data-code="+252">Somalia</option>
                                    <option value="ZA" data-flag="images/flags/za.png" data-code="+27">South Africa</option>
                                    <option value="SS" data-flag="images/flags/ss.png" data-code="+211">South Sudan</option>
                                    <option value="SD" data-flag="images/flags/sd.png" data-code="+249">Sudan</option>
                                    <option value="TZ" data-flag="images/flags/tz.png" data-code="+255">Tanzania</option>
                                    <option value="TG" data-flag="images/flags/tg.png" data-code="+228">Togo</option>
                                    <option value="TN" data-flag="images/flags/tn.png" data-code="+216">Tunisia</option>
                                    <option value="UG" data-flag="images/flags/ug.png" data-code="+256">Uganda</option>
                                    <option value="EH" data-flag="images/flags/eh.png" data-code="+212">Western Sahara</option>
                                    <option value="ZM" data-flag="images/flags/zm.png" data-code="+260">Zambia</option>
                                    <option value="ZW" data-flag="images/flags/zw.png" data-code="+263">Zimbabwe</option>
                                </select>
                            </div>
                            <div class="form-group">
                                    <label>Your Phone Number</label>
                                    <input type="tel" name="phone" id="phone" class="my-form-control" placeholder="Enter Your Phone Number" required>
                                </div>
                                <div class="form-group">
                                    <label>Password</label>
                                    <input type="text" name="password" class="my-form-control" placeholder="Enter Your Password" required>
                                </div>
                                <div class="form-group">
                                    <label>Confirm Password</label>
                                    <input type="text"  name="confirm_password" class="my-form-control" placeholder="Enter Your Confirm Password" required>
                                </div>
                                <div class="custom-control custom-checkbox">
                                    <input type="checkbox" class="custom-control-input" id="customCheck1" required>
                                    <label class="custom-control-label" for="customCheck1">
                                        I agree to the <a href="#">Terms, Privacy Policy and Fees</a>
                                    </label>
                                </div>
                                <div class="button-wrapper">
                                    <button type="submit" class="custom-button2">Register Now</button>
                                    <p class="or-signup">
                                        Already have an account? <a href="#" data-toggle="modal" data-target="#loginModal">
                                            Login
                                        </a>
                                    </p>
                                </div>
                                
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Register Area -->

    <!-<!-- Login Area -->
<div class="modal fade log-reg-modal-wrapper log" id="loginModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body">
                <div class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </div>
                <div class="log-reg-inner">
                    <h2 class="title">
                        Welcome to YesFreeLotto
                    </h2>
                    <div class="main-content">
                        <form action="login.php" method="POST">
                            <div class="form-group">
                                <label>Your Email</label>
                                <input type="email" name="email" class="my-form-control" placeholder="Enter Your Email">
                            </div>
                            <div class="form-group">
                                <label>Password</label>
                                <input type="password" name="password" class="my-form-control" placeholder="Enter Your Password">
                            </div>
                           
                            <p class="f-pass">
                                Forgot your password? <a href="#">recover password</a>
                            </p>
                            <div class="button-wrapper">
                                <button type="submit" class="custom-button2">Sign In</button>
                            </div>
                            <div class="or log">
                                <p></p>
                            </div>
                            <div class="or-content">
                                
                                <p class="or-signup">
                                    Don't have an account? <a href="#" data-toggle="modal" data-target="#registerModal">
                                        Sign up here
                                    </a>
                                </p>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<!-- Add JavaScript to change the flag based on selection -->
<script>
    document.getElementById('countrySelect').addEventListener('change', function() {
        const selectedOption = this.options[this.selectedIndex];
        const flagUrl = selectedOption.getAttribute('data-flag');
        this.style.backgroundImage = `url('${flagUrl}')`;
    });

    const countrySelect = document.getElementById('countrySelect');
        const phoneInput = document.getElementById('phone');

        countrySelect.addEventListener('change', () => {
            const countryCode = countrySelect.options[countrySelect.selectedIndex].getAttribute('data-code');
            phoneInput.value = countryCode + ' ';
        });

    document.getElementById('registrationForm').addEventListener('submit', (e) => {
        if (!document.getElementById('customCheck1').checked) {
            e.preventDefault();
            alert('Please agree to the Terms, Privacy Policy and Fees');
        }
    });
</script>