<?php
include 'header.php';
?>

<!-- ==========Breadcrumb-Section========== -->
<section class="breadcrumb-area">
    <div class="container">
        <div class="content">
            <h2 class="title">
                Blog
            </h2>
            <ul class="breadcrumb-list extra-padding">
                <li>
                    <a href="index.html">
                        Home
                    </a>
                </li>
                <li>
                    <a href="#">Blog</a>
                </li>
            </ul>
        </div>
    </div>
</section>
<!-- ==========Breadcrumb-Section========== -->

<!-- ==========Blog-Page========== -->
<section class="blog-page">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <?php
                // Database connection

                // Define how many results you want per page
                $results_per_page = 5;

                // Find out the number of results stored in database
                $sql = "SELECT COUNT(*) AS total FROM blogs";
                $result = $conn->query($sql);
                $row = $result->fetch_assoc();
                $total_results = $row['total'];

                // Determine the total number of pages available
                $number_of_pages = ceil($total_results / $results_per_page);

                // Determine which page number visitor is currently on
                if (!isset($_GET['page'])) {
                    $page = 1; // default to page 1
                } else {
                    $page = $_GET['page'];
                }

                // Determine the SQL LIMIT starting number for the results on the displaying page
                $starting_limit = ($page - 1) * $results_per_page;

                // Fetch blog data for the current page
                $sql = "SELECT * FROM blogs LIMIT " . $starting_limit . ',' . $results_per_page;
                $result = $conn->query($sql);

                // Check if there are results
                if ($result->num_rows > 0) {
                    // Output data for each row
                    while ($row = $result->fetch_assoc()) {
                        // Get the content (assuming you want to display from the 'content' field)
                        $content = $row['content']; // or use $row['content1'] if you want that instead

                        // Split the content into words
                        $words = explode(' ', $content);

                        // Get the first 30 words
                        $first30Words = array_slice($words, 0, 30);

                        // Join the words back into a string
                        $shortContent = implode(' ', $first30Words);

                        echo '<div class="single-blog">
                                <div class="img">
                                    <img src="' . htmlspecialchars($row['image']) . '" alt="">
                                </div>
                                <div class="content">
                                    <h4 class="title">' . htmlspecialchars($row['title']) . '</h4>
                                    <ul class="meta-list">
                                        <li>
                                            <div class="post-by">
                                                <img src="assets/images/post-by.png" alt="">
                                                By <a href="#">' . htmlspecialchars($row['author']) . '</a>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="date">' . date("d M, Y", strtotime($row['date'])) . '</div>
                                        </li>
                                    </ul>
                                    <p class="text">' . htmlspecialchars($shortContent) . '...</p> <!-- Displaying only first 30 words -->
                                     <a href="blog-details.php?id=' . $row['id'] . '" class="custom-button2">Read More</a>
                                </div>
                            </div>';
                    }
                } else {
                    echo "No blog posts found.";
                }

                // Close connection
                $conn->close();
                ?>
            </div>
            <div class="col-lg-12 text-center">
                <ul class="pagination">
                    <?php
                    // Display links for the pages
                    for ($page = 1; $page <= $number_of_pages; $page++) {
                        if ($page == $current_page) {
                            echo '<li class="active">' . $page . '</li>';
                        } else {
                            echo '<li><a href="blog.php?page=' . $page . '">' . $page . '</a></li>';
                        }
                    }
                    ?>
                    <li>
                        <i class="fas fa-chevron-right"></i>
                    </li>
                </ul>
            </div>
        </div>
    </div>
</section>
<!-- ==========Blog-Page========== -->
<?php include 'footer.php'; ?>